/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

#define A (0.15*3.0*sin(iGlobalTime)) 
#define L 2.0

float text(vec2 pos) {
  // return texture2D(iChannel0,pos).r;
  return pow(max(0.,sin(8.*3.1416*pos.x)*sin(8.*3.1416*pos.y)),.8)+.3*(1.-cos(.025*6.28*iGlobalTime));
}

void main(void)
{
	 vec2 uv = 2.0*(gl_FragCoord.xy / iResolution.y - vec2(0.9,0.5));
    float r = length(uv), a = atan(uv.y,uv.x);
    
    // concentric circles
    float v = pow(max(0.,sin(3.0*6.283*log(r)-0.0*2.0*iGlobalTime)),0.8);
    //float v = pow(max(0.,sin(.5*3.*6.283*log(r)-0.*2.*t)),5.);
    
    // pattern
    vec2 grid = vec2((a+0.0*iGlobalTime)*4.0/3.1416,log(r)+ a/3.1416);
    float t = text(grid+vec2(0.0,(A/L)*sin(L*grid.x)));
    v *= t;
    //v = .8*(v-1.) +t;
    
	gl_FragColor = vec4(v);
}